/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.dialog;

import filenet.vw.api.VWException;
import filenet.vw.api.VWParticipant;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.VWTrkDataModel;
import filenet.vw.toolkit.runtime.VWTrkParticipant;
import filenet.vw.toolkit.runtime.VWTrkStep;
import filenet.vw.toolkit.runtime.VWTrkStepOccurrence;
import filenet.vw.toolkit.runtime.dialog.VWConfirmRefreshDialog;
import filenet.vw.toolkit.runtime.dialog.VWLockWork;
import filenet.vw.toolkit.runtime.resources.VWResource;
import filenet.vw.toolkit.runtime.table.VWParticipantCellRenderer;
import filenet.vw.toolkit.runtime.table.VWStepNParticipantRenderer;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeListener;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeSource;
import filenet.vw.toolkit.utils.event.VWPropertyChangeEvent;
import filenet.vw.toolkit.utils.event.VWPropertyChangeNotifier;
import filenet.vw.toolkit.utils.table.VWTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

public final class VWReturnWorkDialog
extends VWModalDialog
implements IVWPropertyChangeListener,
MouseListener {
    VWTrkDataModel m_trackerDataModel = null;
    VWStepNParticipantRenderer m_stepAndParticipantRenderer = new VWStepNParticipantRenderer();
    private Vector m_activeSteps = null;
    private Object m_selected = null;
    private VWTrkStepOccurrence m_occurrence = null;
    private Vector m_participants = new Vector();
    private String m_queueName = null;
    private JLabel m_stepLabel = null;
    private JComboBox m_stepCombo = null;
    private DefaultComboBoxModel m_stepModel = null;
    private ItemListener m_stepComboItemListener = null;
    private JLabel m_workQueueLabel = null;
    private JLabel m_queueNameUI = null;
    private JLabel m_workLabel = null;
    private VWTable m_workTable = null;
    private VWParticipantCellRenderer m_participantCellRenderer = new VWParticipantCellRenderer();
    private static int PARTICIPANT_COL = 0;
    private static int RETURN_TO_COL = 1;
    private AbstractTableModel m_workModel = new AbstractTableModel(){
        String[] m_columnHeader = new String[]{VWResource.s_participant, VWResource.s_returnTo};

        public int getRowCount() {
            return VWReturnWorkDialog.this.m_participants.size();
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int col) {
            return this.m_columnHeader[col];
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public Object getValueAt(int row, int col) {
            if (col >= this.getColumnCount()) {
                return null;
            }
            if (row >= this.getRowCount()) {
                return null;
            }
            VWTrkParticipant participant = (VWTrkParticipant)VWReturnWorkDialog.this.m_participants.elementAt(row);
            if (col == PARTICIPANT_COL) {
                return participant;
            }
            if (col == RETURN_TO_COL) {
                return participant.getReturnToSourceName();
            }
            return null;
        }
    };
    private JRadioButton m_appendRadio = null;
    private JRadioButton m_replaceRadio = null;
    private JLabel m_commentsLabel = null;
    private JTextArea m_commentsUI = null;
    private JTextArea m_newCommentsUI = null;
    private String m_comments = "";
    private JButton m_okButton = null;
    private ActionListener m_okButtonActionListener = null;
    private JButton m_applyButton = null;
    private ActionListener m_applyButtonActionListener = null;
    private JButton m_cancelButton = null;
    private ActionListener m_cancelButtonActionListener = null;
    private JButton m_helpButton = null;
    private ActionListener m_helpButtonActionListener = null;
    private boolean m_bCanceled = true;
    private boolean m_bInitializing = false;
    private VWLockWork m_lockWork = null;

    public VWReturnWorkDialog(Frame parent, VWTrkDataModel trackerDataModel) throws Exception {
        super(parent);
        this.m_trackerDataModel = trackerDataModel;
        if (trackerDataModel == null) {
            throw new Exception(VWResource.s_nullTrackerDataModel.toString(VWResource.s_returnWorkDialogTitle));
        }
        this.initData();
        this.setupLayout();
        this.updateControls();
        VWPropertyChangeNotifier.addPropertyChangeListener(this);
        Vector selectedSteps = trackerDataModel.getSelectedSteps();
        if (selectedSteps != null && selectedSteps.size() > 0 && this.m_activeSteps != null && this.m_activeSteps.size() > 0) {
            for (int i = 0; i < selectedSteps.size(); ++i) {
                Object obj = selectedSteps.elementAt(i);
                if (obj == null || this.m_stepModel.getIndexOf(obj) < 0) continue;
                Object selected = this.m_stepModel.getSelectedItem();
                if (selected == obj) break;
                this.m_stepModel.setSelectedItem(obj);
                break;
            }
        }
    }

    protected void initData() {
        this.m_bInitializing = true;
        Object selected = null;
        this.m_activeSteps = this.m_trackerDataModel.getActiveSteps();
        if (this.m_stepModel == null) {
            this.m_stepModel = new DefaultComboBoxModel();
        } else {
            this.m_stepModel.removeAllElements();
        }
        if (this.m_activeSteps != null && this.m_activeSteps.size() > 0) {
            for (int i = 0; i < this.m_activeSteps.size(); ++i) {
                Vector occurrences;
                VWTrkStep step = (VWTrkStep)this.m_activeSteps.elementAt(i);
                if (step == null || (occurrences = step.getActiveOccurrences()) == null || occurrences.size() <= 0) continue;
                if (occurrences.size() == 1) {
                    this.m_stepModel.addElement(step);
                    if (this.m_selected == null || this.m_selected != step) continue;
                    selected = this.m_selected;
                    this.m_selected = null;
                    continue;
                }
                for (int j = 0; j < occurrences.size(); ++j) {
                    Object obj = occurrences.elementAt(j);
                    if (obj == null || !(obj instanceof VWTrkStepOccurrence)) continue;
                    this.m_stepModel.addElement(obj);
                    if (this.m_selected == null || this.m_selected != obj) continue;
                    selected = this.m_selected;
                    this.m_selected = null;
                }
            }
            if (selected == null && this.m_stepModel.getSize() > 0) {
                selected = this.m_stepModel.getElementAt(0);
            }
            this.m_stepModel.setSelectedItem(selected);
        } else {
            selected = null;
        }
        this.initStep(selected);
        this.m_bInitializing = false;
    }

    private void initParticipants() {
        Vector participants = null;
        if (this.m_occurrence != null) {
            participants = this.m_occurrence.getActiveParticipants();
        }
        if (this.m_participants != null) {
            this.m_participants.removeAllElements();
        } else {
            this.m_participants = new Vector();
        }
        this.m_queueName = null;
        if (participants != null && participants.size() > 0) {
            for (int i = 0; i < participants.size(); ++i) {
                Object obj = participants.elementAt(i);
                if (!(obj instanceof VWTrkParticipant)) continue;
                VWTrkParticipant participant = (VWTrkParticipant)obj;
                if (this.m_queueName == null) {
                    this.m_queueName = participant.getQueueName();
                }
                if (!participant.getCanReturnToSource() || participant.isLockedByOther()) continue;
                int loc = this.m_participants.size();
                VWParticipant vwParticipant = participant.getParticipant();
                for (int j = 0; j < this.m_participants.size(); ++j) {
                    VWTrkParticipant p = (VWTrkParticipant)this.m_participants.elementAt(j);
                    VWParticipant tempParticipant = p.getParticipant();
                    if (VWStringUtils.compareIgnoreCase(vwParticipant.getParticipantName(), tempParticipant.getParticipantName()) > 0) continue;
                    loc = j;
                    break;
                }
                if (loc >= this.m_participants.size()) {
                    this.m_participants.addElement(participant);
                    continue;
                }
                this.m_participants.insertElementAt(participant, loc);
            }
        }
        this.m_workModel.fireTableDataChanged();
    }

    protected void setupLayout() {
        Container contentPane = this.getContentPane();
        this.setResizable(true);
        Dimension dim = VWStringUtils.stringToDimension(VWResource.s_returnWorkDialogDim);
        if (dim == null) {
            dim = new Dimension(450, 450);
        }
        this.setSize(dim.width, dim.height);
        this.setVisible(false);
        this.setTitle(VWResource.s_returnWorkDialogTitle);
        this.m_stepLabel = new JLabel(VWResource.s_label.toString(VWResource.s_step));
        this.m_stepModel = this.m_activeSteps == null || this.m_activeSteps.size() == 0 ? new DefaultComboBoxModel() : new DefaultComboBoxModel(this.m_activeSteps);
        this.m_stepCombo = new JComboBox(this.m_stepModel);
        this.m_stepCombo.setRenderer(this.m_stepAndParticipantRenderer);
        this.m_workQueueLabel = new JLabel(VWResource.s_label.toString(VWResource.s_queue));
        this.m_queueNameUI = new JLabel("", 2);
        this.m_workLabel = new JLabel(VWResource.s_label.toString(VWResource.s_work));
        this.m_workTable = new VWTable(this.m_workModel);
        TableColumn column = this.m_workTable.getColumnModel().getColumn(PARTICIPANT_COL);
        column.setCellRenderer(this.m_participantCellRenderer);
        this.m_workTable.setRowSelectionAllowed(true);
        this.m_workTable.setColumnSelectionAllowed(false);
        this.m_okButton = new JButton(VWResource.s_ok);
        this.m_applyButton = new JButton(VWResource.s_apply);
        this.m_cancelButton = new JButton(VWResource.s_cancel);
        this.m_helpButton = new JButton(VWResource.s_help);
        JPanel mainPanel = new JPanel();
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 23;
        c.fill = 0;
        c.insets = new Insets(4, 4, 4, 4);
        mainPanel.add((Component)this.m_stepLabel, c);
        c.gridx = 1;
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.fill = 1;
        mainPanel.add((Component)this.m_stepCombo, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.fill = 0;
        mainPanel.add((Component)this.m_workQueueLabel, c);
        c.gridx = 1;
        c.gridwidth = 0;
        c.weightx = 1.0;
        mainPanel.add((Component)this.m_queueNameUI, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.anchor = 23;
        c.fill = 0;
        mainPanel.add((Component)this.m_workLabel, c);
        c.gridx = 1;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 2.0;
        mainPanel.add((Component)new JScrollPane(this.m_workTable), c);
        JPanel commentsPanel = new JPanel();
        this.setupCommentsPanel(commentsPanel);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.weighty = 3.0;
        c.fill = 1;
        c.insets = new Insets(6, 0, 0, 0);
        mainPanel.add((Component)commentsPanel, c);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        buttonPanel.add(this.m_okButton);
        buttonPanel.add(this.m_applyButton);
        buttonPanel.add(this.m_cancelButton);
        buttonPanel.add(this.m_helpButton);
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(2, 0, 10, 0));
        contentPane.setLayout(new BorderLayout(6, 6));
        contentPane.add((Component)mainPanel, "Center");
        contentPane.add((Component)buttonPanel, "Last");
        this.m_stepComboItemListener = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (VWReturnWorkDialog.this.m_bInitializing) {
                    return;
                }
                if (e.getStateChange() == 1) {
                    VWReturnWorkDialog.this.performStepSelected();
                }
            }
        };
        this.m_stepCombo.addItemListener(this.m_stepComboItemListener);
        this.m_okButtonActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VWReturnWorkDialog.this.m_bCanceled = false;
                VWReturnWorkDialog.this.performReturnWork();
                VWReturnWorkDialog.this.setVisible(false);
                VWReturnWorkDialog.this.removePropertyChangeListener();
            }
        };
        this.m_okButton.addActionListener(this.m_okButtonActionListener);
        this.m_applyButtonActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VWReturnWorkDialog.this.performReturnWork();
            }
        };
        this.m_applyButton.addActionListener(this.m_applyButtonActionListener);
        this.m_cancelButtonActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VWReturnWorkDialog.this.m_bCanceled = true;
                VWReturnWorkDialog.this.setVisible(false);
                VWReturnWorkDialog.this.removePropertyChangeListener();
            }
        };
        this.m_cancelButton.addActionListener(this.m_cancelButtonActionListener);
        this.m_helpButtonActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VWHelp.displayPage("tracker/vwreturnworkdialog.htm");
            }
        };
        this.m_helpButton.addActionListener(this.m_helpButtonActionListener);
        this.m_workTable.addMouseListener(this);
        this.updateComments();
    }

    private void setupCommentsPanel(JPanel panel) {
        this.m_commentsUI = new JTextArea();
        this.m_commentsUI.setLineWrap(true);
        this.m_commentsUI.setWrapStyleWord(false);
        this.m_commentsUI.setEditable(false);
        this.m_newCommentsUI = new JTextArea();
        this.m_newCommentsUI.setLineWrap(true);
        this.m_newCommentsUI.setWrapStyleWord(false);
        ButtonGroup grp = new ButtonGroup();
        this.m_appendRadio = new JRadioButton(VWResource.s_append);
        this.m_replaceRadio = new JRadioButton(VWResource.s_replace);
        grp.add(this.m_appendRadio);
        grp.add(this.m_replaceRadio);
        this.m_appendRadio.setSelected(true);
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), VWResource.s_label.toString(VWResource.s_comments)));
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 23;
        c.insets = new Insets(0, 6, 0, 0);
        panel.add((Component)this.m_appendRadio, c);
        c.gridx = 1;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 0, 0);
        c.anchor = 10;
        panel.add((Component)this.m_replaceRadio, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        c.anchor = 23;
        c.fill = 0;
        panel.add((Component)new JLabel(VWResource.s_currentComments), c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        panel.add((Component)new JScrollPane(this.m_commentsUI), c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        panel.add((Component)new JLabel(VWResource.s_enterComments), c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        panel.add((Component)new JScrollPane(this.m_newCommentsUI), c);
    }

    public void addNotify() {
        super.addNotify();
        Font boldFont = null;
        Font font = null;
        font = this.getFont();
        if (font != null) {
            boldFont = new Font(font.getName(), 1, font.getSize());
        }
        if (boldFont != null) {
            this.m_stepLabel.setFont(boldFont);
            this.m_workQueueLabel.setFont(boldFont);
            this.m_workLabel.setFont(boldFont);
        }
    }

    private void updateControls() {
        if (this.m_selected != null) {
            if (this.m_queueName != null) {
                this.m_queueNameUI.setText(this.m_queueName);
            } else {
                this.m_queueNameUI.setText("");
            }
        } else {
            this.m_workQueueLabel.setEnabled(false);
            this.m_queueNameUI.setEnabled(false);
            this.m_workLabel.setEnabled(false);
            this.m_workTable.setEnabled(false);
        }
        this.setButtonState();
    }

    public boolean isCanceled() {
        return this.m_bCanceled;
    }

    private void performStepSelected() {
        Object obj = this.m_stepCombo.getSelectedItem();
        if (obj != this.m_selected) {
            this.initStep(obj);
            this.updateControls();
        }
    }

    private void updateComments() {
        this.m_comments = "";
        VWTrkParticipant participant = null;
        int[] selection = this.m_workTable.getSelectedRows();
        if (selection != null && selection.length > 0) {
            if (selection.length == 1) {
                Object obj = this.m_participants.elementAt(selection[0]);
                if (obj != null && obj instanceof VWTrkParticipant) {
                    participant = (VWTrkParticipant)obj;
                }
                this.m_commentsUI.setEnabled(true);
                try {
                    this.m_comments = participant.getComments();
                }
                catch (VWException ex) {
                    this.m_comments = "";
                }
            } else {
                this.m_comments = VWResource.s_variousComments;
            }
        } else {
            this.m_commentsUI.setEnabled(false);
        }
        this.m_commentsUI.setText(this.m_comments);
    }

    private void setButtonState() {
        boolean bEnable = false;
        int[] selection = this.m_workTable.getSelectedRows();
        if (selection != null && selection.length > 0) {
            bEnable = true;
        }
        this.m_applyButton.setEnabled(bEnable);
        this.m_okButton.setEnabled(bEnable);
    }

    private boolean confirmReturnWork() {
        int option = JOptionPane.showConfirmDialog(this, VWResource.s_areYouSureReturnWork, VWResource.s_returnWorkDialogTitle, 0, 3);
        return option == 0;
    }

    private void performReturnWork() {
        if (!this.confirmReturnWork()) {
            return;
        }
        boolean bAnyFailed = false;
        boolean bAnySucceeded = false;
        VWTrkParticipant participant = null;
        Cursor currentCursor = null;
        String newComments = this.m_newCommentsUI.getText();
        String comments = null;
        boolean bAppendComments = this.m_appendRadio.isSelected();
        int[] selectedIndices = this.m_workTable.getSelectedRows();
        if (selectedIndices != null) {
            Object[] selectedParticipants = new Object[selectedIndices.length];
            currentCursor = this.getCursor();
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (int i = 0; i < selectedIndices.length; ++i) {
                selectedParticipants[i] = this.m_workModel.getValueAt(selectedIndices[i], PARTICIPANT_COL);
            }
            boolean bLocked = true;
            try {
                this.m_lockWork = new VWLockWork((Dialog)this, this.m_trackerDataModel, selectedParticipants);
                bLocked = this.m_lockWork.isSuccess();
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                JOptionPane.showMessageDialog(this, ex.getLocalizedMessage(), VWResource.s_returnWorkDialogTitle, 0, null);
                this.m_lockWork = null;
            }
            if (bLocked) {
                for (int i = 0; i < selectedParticipants.length; ++i) {
                    participant = (VWTrkParticipant)selectedParticipants[i];
                    if (bAppendComments) {
                        try {
                            comments = participant.getComments();
                        }
                        catch (VWException ex) {
                            // empty catch block
                        }
                        if (comments == null) {
                            comments = "";
                        }
                        if (newComments != null && newComments.length() > 0) {
                            if (comments.length() > 0) {
                                comments = comments + "\n";
                            }
                            comments = comments + newComments;
                        }
                    } else {
                        comments = newComments != null ? newComments : null;
                    }
                    try {
                        participant.doReturnToSource(comments);
                        bAnySucceeded = true;
                        continue;
                    }
                    catch (VWException ex) {
                        VWDebug.logException(ex);
                        JOptionPane.showMessageDialog(this, ex.getLocalizedMessage(), VWResource.s_returnWorkDialogTitle, 0, null);
                        bAnyFailed = true;
                    }
                }
            } else {
                if (this.m_lockWork != null) {
                    this.m_lockWork.unlock();
                }
                JOptionPane.showMessageDialog(this.getParent(), VWResource.s_someCantBeLocked, VWResource.s_returnWorkDialogTitle, 0, null);
            }
            this.setCursor(currentCursor);
        }
        if (bAnySucceeded) {
            boolean bSave = true;
            boolean bAltered = false;
            if (this.m_selected instanceof VWTrkStep) {
                bAltered = ((VWTrkStep)this.m_selected).isAltered();
            } else if (this.m_selected instanceof VWTrkStepOccurrence) {
                bAltered = ((VWTrkStepOccurrence)this.m_selected).isAltered();
            }
            if (bAltered) {
                VWConfirmRefreshDialog confirmRefreshDialog = new VWConfirmRefreshDialog((Dialog)this, false);
                confirmRefreshDialog.setVisible(true);
                bSave = confirmRefreshDialog.isYes();
            }
            currentCursor = this.getCursor();
            this.setCursor(Cursor.getPredefinedCursor(3));
            Vector<Object> steps = new Vector<Object>();
            if (this.m_selected instanceof VWTrkStep) {
                steps.addElement(this.m_selected);
            } else if (this.m_selected instanceof VWTrkStepOccurrence) {
                steps.addElement(((VWTrkStepOccurrence)this.m_selected).getStep());
            }
            this.m_trackerDataModel.refresh(steps, bSave);
            this.setCursor(currentCursor);
        }
        if (bAnyFailed) {
            if (bAnySucceeded) {
                JOptionPane.showMessageDialog(this.getParent(), VWResource.s_someFailedToReturn, VWResource.s_returnWorkDialogTitle, 0, null);
            } else {
                JOptionPane.showMessageDialog(this.getParent(), VWResource.s_failedToReturn, VWResource.s_returnWorkDialogTitle, 0, null);
            }
        }
    }

    private void initStep(Object obj) {
        Vector occurrences;
        if (this.m_selected != null && this.m_selected == obj) {
            return;
        }
        this.m_selected = obj;
        this.m_occurrence = obj instanceof VWTrkStep ? ((occurrences = ((VWTrkStep)obj).getActiveOccurrences()) != null && occurrences.size() > 0 ? (VWTrkStepOccurrence)occurrences.elementAt(0) : null) : (obj instanceof VWTrkStepOccurrence ? (VWTrkStepOccurrence)obj : null);
        this.initParticipants();
    }

    public void propertyChange(VWPropertyChangeEvent event) {
        Object obj = event.getSource();
        if (obj instanceof IVWPropertyChangeSource) {
            int type = event.getID();
            switch (type) {
                case 704: 
                case 705: {
                    Cursor currentCursor = null;
                    currentCursor = this.getCursor();
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    this.initData();
                    this.updateControls();
                    this.setCursor(currentCursor);
                    break;
                }
            }
        }
    }

    private void removePropertyChangeListener() {
        VWPropertyChangeNotifier.removePropertyChangeListener(this);
    }

    public void mouseClicked(MouseEvent evt) {
        this.updateControls();
        this.updateComments();
    }

    public void mouseReleased(MouseEvent event) {
        this.updateControls();
        this.updateComments();
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public void mousePressed(MouseEvent event) {
    }

    public boolean isCanReturnWork() {
        return this.m_participants != null && this.m_participants.size() > 0;
    }

    public void removeReferences() {
        super.removeReferences();
        VWPropertyChangeNotifier.removePropertyChangeListener(this);
        this.m_trackerDataModel = null;
        this.m_stepAndParticipantRenderer = null;
        this.m_activeSteps = null;
        this.m_selected = null;
        this.m_occurrence = null;
        if (this.m_participants != null) {
            this.m_participants.removeAllElements();
            this.m_participants = null;
        }
        this.m_queueName = null;
        this.m_stepLabel = null;
        if (this.m_stepCombo != null) {
            this.m_stepCombo.removeItemListener(this.m_stepComboItemListener);
            this.m_stepCombo = null;
        }
        this.m_stepModel = null;
        this.m_workQueueLabel = null;
        this.m_queueNameUI = null;
        this.m_workLabel = null;
        if (this.m_workTable != null) {
            this.m_workTable.removeMouseListener(this);
            this.m_workTable.removeReferences();
            this.m_workTable = null;
        }
        this.m_participantCellRenderer = null;
        this.m_workModel = null;
        this.m_appendRadio = null;
        this.m_replaceRadio = null;
        this.m_commentsLabel = null;
        this.m_commentsUI = null;
        this.m_newCommentsUI = null;
        this.m_comments = null;
        if (this.m_okButton != null) {
            this.m_okButton.removeActionListener(this.m_okButtonActionListener);
            this.m_okButtonActionListener = null;
            this.m_okButton = null;
        }
        if (this.m_applyButton != null) {
            this.m_applyButton.removeActionListener(this.m_applyButtonActionListener);
            this.m_applyButtonActionListener = null;
            this.m_applyButton = null;
        }
        if (this.m_helpButton != null) {
            this.m_helpButton.removeActionListener(this.m_helpButtonActionListener);
            this.m_helpButtonActionListener = null;
            this.m_helpButton = null;
        }
        if (this.m_cancelButton != null) {
            this.m_cancelButton.removeActionListener(this.m_cancelButtonActionListener);
            this.m_cancelButtonActionListener = null;
            this.m_cancelButton = null;
        }
        if (this.m_lockWork != null) {
            this.m_lockWork.removeReferences();
            this.m_lockWork = null;
        }
        this.removeAll();
    }
}

